#!/bin/bash
#
# Add user in /mnt/factory/shadow
set -e
if [ $# -lt 3 ]; then
        echo "Missing arguments."
	echo "Usage: $0 <username> <password> <role> [<daysexpiration>, 0=reset,-1=nochange] [<warningdays, 0=reset,-1=nochange>]"
        exit 1
fi

FACTORY_MNT="/mnt/factory/"
ETC_MNT="/etc/"
USER=$1
PASSW=$2
ROLE=$3
DAYS=$4
WDAYS=$5
LINECOUNT=0
GROUPCOUNT=0

[ -f /etc/shadow ] && LINECOUNT="$(cat /etc/shadow | grep "^$USER:" | wc -l)"
if [ $LINECOUNT -gt 0 ]; then
        echo "Invalid user $USER already existing"
        exit 2
fi


if [ "${ROLE}" != "admin" ] && [ "${ROLE}" != "user" ]; then
	echo "Invalid role ${ROLE}"
	exit 3
fi

[ "${ROLE}" == "user" ] && GROUPCOUNT="$(grep "^$USER:" /etc/group | wc -l)"

rm -f "${ETC_MNT}shadow" && cp "${FACTORY_MNT}shadow" "${ETC_MNT}"
rm -f "${ETC_MNT}group" && cp "${FACTORY_MNT}group" "${ETC_MNT}"
rm -f "${ETC_MNT}passwd" && cp "${FACTORY_MNT}passwd" "${ETC_MNT}"
if [ "${ROLE}" == "user" ]; then
   groupadd -g 20000 user || true
fi
if [ "${USER}" == "user" ] && [ "${ROLE}" == "user" ]; then
   useradd -g user "${USER}"
else
   [ $GROUPCOUNT -eq 0 ] && useradd "${USER}"
   [ $GROUPCOUNT -ne 0 ] && useradd -g $USER $USER
fi
passwd $USER<<OEF
$PASSW
$PASSW
OEF

if [ "${ROLE}" == "admin" ]; then
	usermod -a -G admin,shadow,data,comm,datetime,fram,io,video,audio,pam_adm ${USER}
else
	usermod -a -G user,data,datetime ${USER}
fi

[ -d "/home/$USER" ] && chown $USER:$USER "/home/$USER"

if [ ! -z "$DAYS" -a "$DAYS" != "-1" ] || [ ! -z "$WDAYS" -a "$WDAYS" != "-1" ]; then
    [ "$DAYS" == "0" ] && DAYS="-1"
    [ "$WDAYS" == "0" ] && WDAYS="-1"
    [ ! -z "$DAYS" -a "$DAYS" != "-1" ] && DAYSOPT="--maxdays $DAYS"
    [ ! -z "$WDAYS" -a "$WDAYS" != "-1" ] && WDAYSOPT="-W $WDAYS"
    chage -I 1 $DAYSOPT $WDAYSOPT ${USER}
fi

mount -o remount,rw "${FACTORY_MNT}"
cp "${ETC_MNT}shadow" "${FACTORY_MNT}" && chgrp shadow "${FACTORY_MNT}shadow"
cp "${ETC_MNT}group" "${FACTORY_MNT}" && chmod 644 "${FACTORY_MNT}group"
cp "${ETC_MNT}passwd" "${FACTORY_MNT}" && chmod 644 "${FACTORY_MNT}passwd"
ln -sfb "${FACTORY_MNT}shadow" "${ETC_MNT}shadow"
ln -sfb "${FACTORY_MNT}group" "${ETC_MNT}group"
ln -sfb "${FACTORY_MNT}passwd" "${ETC_MNT}passwd"
sync
mount -o remount,ro "${FACTORY_MNT}"

exit 0
